<?php

use Sabre\DAV;

// Don't load WordPress theme support functionality
define('SHORTINIT', true);
define('WP_USE_THEMES', false);

// Load WordPress
require __DIR__ . '/../../../wp-load.php';

// Load common functions (because of SHORTINIT plugin is not loaded)
require __DIR__ . '/common.php';

if (!wpdav_is_user_authenticated()) {
    header('HTTP/1.1 401 Unauthorized');
    echo '<h1>401 Unauthorized</h1>';
    exit;
}

// Root directory
$root_directory = new DAV\FS\Directory( ABSPATH );

// DAV Server
$server = new DAV\Server($root_directory);
$server->setBaseUri("/" . WPDAV_PLUGIN_REST_PREFIX . "/" . WPDAV_WEBDAV_ROUTE . "/");

// Get PHP Temp directory for Locks
$lock_backend = new DAV\Locks\Backend\File(sys_get_temp_dir() . '/wpdav_locks');
$lock_plugin = new DAV\Locks\Plugin($lock_backend);

$server->addPlugin($lock_plugin);
$server->addPlugin(new DAV\Browser\Plugin());

$server->start();
